# Section Machine Learning
[*Return*](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/README.md)
索引编号|英文术语|中文翻译|常用缩写|来源&扩展|备注
---|---|---|---|---|---
AITD-00000|0-1 Loss Function|0-1损失函数||[1]||
AITD-00003|Accept-Reject Sampling Method|接受-拒绝抽样法/接受-拒绝采样法||[1]||
AITD-00006|Accumulated Error Backpropagation|累积误差反向传播||[1]||
AITD-00007|Accuracy|准确率||[[1]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-00010|Acquisition Function|采集函数||[[1]](https://www.jiqizhixin.com/articles/2017-08-18-5)||
AITD-00011|Action|动作||[1]||
AITD-00015|Activation Function|激活函数||[[1]](https://www.jiqizhixin.com/articles/2017-06-11-4)[[2]](https://www.jiqizhixin.com/articles/2017-06-18-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-00016|Active Learning|主动学习||[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-00020|Adaptive Bitrate Algorithm|自适应比特率算法|ABR|[1]||
AITD-00021|Adaptive Boosting|AdaBoost||[1]||
AITD-00022|Adaptive Gradient Algorithm|AdaGrad||[1]||
AITD-00023|Adaptive Moment Estimation Algorithm|Adam算法|Adam|[1]||
AITD-00024|Adaptive Resonance Theory|自适应谐振理论|ART|[1]||
AITD-00025|Additive Model|加性模型||[1]||
AITD-00032|Affinity Matrix|亲和矩阵||[1]||
AITD-00033|Agent|智能体||[[1]](https://www.jiqizhixin.com/articles/2017-04-06-6)[[2]](https://www.jiqizhixin.com/articles/2017-06-15-6)[[3]](https://www.jiqizhixin.com/articles/2017-06-10-2)[[4]](https://www.jiqizhixin.com/articles/2017-06-29-5)||
AITD-00036|Algorithm|算法||[[1]](https://jiqizhixin.github.io/AI-Terminology-page/)[[2]](https://www.jiqizhixin.com/articles/2017-05-23-4)[[3]](https://www.jiqizhixin.com/articles/2017-06-04-2)||
AITD-00040|Alpha-Beta Pruning|α-β修剪法||[1]||
AITD-00046|Anomaly Detection|异常检测||[1]||
AITD-00052|Approximate Inference|近似推断||[1]||
AITD-00056|Area Under ROC Curve|AUC（ROC曲线下方面积，度量分类模型好坏的标准）|AUC|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-00059|Artificial Intelligence|人工智能|AI|[[1]](https://www.jiqizhixin.com/articles/2017-05-21-4)[[2]](https://www.jiqizhixin.com/articles/2017-05-21-7)[[3]](https://www.jiqizhixin.com/articles/2017-05-17-16)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)[[5]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|机器学习|
AITD-00060|Artificial Neural Network|人工神经网络|ANN|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)|机器学习|
AITD-00061|Artificial Neuron|人工神经元||[1]||
AITD-00069|Attention|注意力||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)|机器学习|
AITD-00072|Attention Mechanism|注意力机制||[[1]](https://www.jiqizhixin.com/articles/2017-06-19-4)[[2]](https://www.jiqizhixin.com/articles/2017-06-14-6)[[3]](https://www.jiqizhixin.com/articles/2017-06-28-5)||
AITD-00075|Attribute|属性||[1]||
AITD-00077|Attribute Space|属性空间||[1]||
AITD-00081|Autoencoder|自编码器|AE|[[1]](https://www.jiqizhixin.com/articles/2017-04-26-5)||
AITD-00082|Automatic Differentiation|自动微分|AD|[[1]](https://www.jiqizhixin.com/articles/2017-11-07)||
AITD-00086|Autoregressive Model|自回归模型|AR|[1]||
AITD-00092|Back Propagation|反向传播|BP|[[1]](https://www.jiqizhixin.com/articles/2016-11-25-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|机器学习|
AITD-00093|Back Propagation Algorithm|反向传播算法||[1]||
AITD-00094|Back Propagation Through Time|随时间反向传播|BPTT|[1]||
AITD-00097|Backward Induction|反向归纳||[1]||
AITD-00098|Backward Search|反向搜索||[1]||
AITD-00099|Bag of Words|词袋|BOW|[1]||
AITD-00101|Bandit|赌博机/老虎机||[1]||
AITD-00105|Base Learner|基学习器||[1]||
AITD-00106|Base Learning Algorithm|基学习算法||[1]||
AITD-00108|Baseline|基准||[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-00110|Batch|批量||[1]||
AITD-00113|Batch Normalization|批量规范化|BN|[1]||
AITD-00117|Bayes Decision Rule|贝叶斯决策准则||[1]||
AITD-00119|Bayes Model Averaging|贝叶斯模型平均|BMA|[1]||
AITD-00120|Bayes Optimal Classifier|贝叶斯最优分类器||[1]||
AITD-00123|Bayes' Theorem|贝叶斯定理||[1]||
AITD-00124|Bayesian Decision Theory|贝叶斯决策理论||[1]||
AITD-00126|Bayesian Inference|贝叶斯推断||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)|统计，机器学习|
AITD-00127|Bayesian Learning|贝叶斯学习||[1]||
AITD-00129|Bayesian Network|贝叶斯网/贝叶斯网络||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)|Network翻译为网或网络皆可，只要统一翻译成网或者统一翻译成网络即可；统计，机器学习|
AITD-00130|Bayesian Optimization|贝叶斯优化||[[1]](https://www.jiqizhixin.com/articles/2017-11-28)||
AITD-00133|Beam Search|束搜索||[[1]](https://www.jiqizhixin.com/articles/2018-01-31-3)||
AITD-00134|Benchmark|基准||[1]||
AITD-00135|Belief Network|信念网/信念网络|BN|[1]|Network翻译为网或网络皆可，只要统一翻译成网或者统一翻译成网络即可|
AITD-00136|Belief Propagation|信念传播|BP|[1]||
AITD-00137|Bellman Equation|贝尔曼方程||[1]||
AITD-00139|Bernoulli Distribution|伯努利分布||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|统计|
AITD-00142|Beta Distribution|贝塔分布||[1]||
AITD-00143|Between-Class Scatter Matrix|类间散度矩阵||[1]||
AITD-00144|BFGS|BFGS||[1]||
AITD-00147|Bias|偏差/偏置||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|看上下语境；机器学习|
AITD-00148|Bias In Affine Function|偏置||[1]|看上下语境|
AITD-00149|Bias In Statistics|偏差||[1]|看上下语境|
AITD-00150|Bias Shift|偏置偏移||[1]||
AITD-00151|Bias-Variance Decomposition|偏差 - 方差分解||[1]||
AITD-00152|Bias-Variance Dilemma|偏差 - 方差困境||[1]||
AITD-00156|Bidirectional Recurrent Neural Network|双向循环神经网络|Bi-RNN|[1]||
AITD-00157|Bigram|二元语法||[1]||
AITD-00158|Bilingual Evaluation Understudy|BLEU||[1]||
AITD-00159|Binary Classification|二分类||[1]||
AITD-00162|Binomial Distribution|二项分布||[1]||
AITD-00164|Binomial Test|二项检验||[1]||
AITD-00172|Boltzmann Distribution|玻尔兹曼分布||[1]||
AITD-00174|Boltzmann Machine|玻尔兹曼机||[[1]](https://www.jiqizhixin.com/articles/2017-10-08-4)||
AITD-00175|Boosting|Boosting（一种模型训练加速方式）||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00177|Bootstrap Aggregating|Bagging||[1]||
AITD-00178|Bootstrap Sampling|自助采样法||[1]||
AITD-00179|Bootstrapping|自助法/自举法||[1]||
AITD-00183|Break-Event Point|平衡点|BEP|[1]||
AITD-00187|Bucketing|分桶||[1]||
AITD-00191|Calculus of Variations|变分法||[1]||
AITD-00198|Cascade-Correlation|级联相关||[1]||
AITD-00199|Catastrophic Forgetting|灾难性遗忘 ||[1]||
AITD-00201|Categorical Distribution|类别分布||[1]||
AITD-00204|Cell|单元||[1]||
AITD-00207|Chain Rule|链式法则||[1]||
AITD-00210|Chebyshev Distance|切比雪夫距离||[1]||
AITD-00214|Class|类别||[1]||
AITD-00217|Class-Imbalance|类别不平衡||[1]||
AITD-00218|Classification|分类||[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)||
AITD-00219|Classification And Regression Tree|分类与回归树|CART|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)||
AITD-00220|Classifier|分类器||[1]||
AITD-00223|Clique|团||[1]||
AITD-00228|Cluster|簇||[[1]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-00230|Cluster Assumption|聚类假设||[1]||
AITD-00231|Clustering|聚类||[[1]](https://www.jiqizhixin.com/articles/2018-01-09)||
AITD-00232|Clustering Ensemble|聚类集成||[1]||
AITD-00236|Co-Training|协同训练||[1]||
AITD-00239|Coding Matrix|编码矩阵||[1]||
AITD-00240|Collaborative Filtering|协同过滤||[[1]](https://www.jiqizhixin.com/articles/2017-12-23-2)||
AITD-00251|Competitive Learning|竞争型学习||[1]||
AITD-00259|Comprehensibility|可解释性||[1]||
AITD-00261|Computation Graph|计算图||[1]||
AITD-00262|Computational Learning Theory|计算学习理论||[1]||
AITD-00271|Conditional Entropy|条件熵||[1]||
AITD-00275|Conditional Probability|条件概率||[1]||
AITD-00277|Conditional Probability Distribution|条件概率分布||[1]||
AITD-00279|Conditional Random Field|条件随机场|CRF|[1]||
AITD-00280|Conditional Risk|条件风险||[1]||
AITD-00283|Confidence|置信度||[1]||
AITD-00285|Confusion Matrix|混淆矩阵||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-00288|Conjugate Distribution|共轭分布||[1]||
AITD-00291|Connection Weight|连接权||[1]||
AITD-00292|Connectionism|连接主义||[1]||
AITD-00293|Consistency|一致性||[1]||
AITD-00295|Constrained Optimization|约束优化||[1]||
AITD-00297|Context Variable|上下文变量||[1]||
AITD-00298|Context Vector|上下文向量||[1]||
AITD-00299|Context Window|上下文窗口||[1]||
AITD-00300|Context Word|上下文词||[1]||
AITD-00302|Contextual Bandit|上下文赌博机/上下文老虎机||[1]||
AITD-00304|Contingency Table|列联表||[1]||
AITD-00308|Continuous Attribute|连续属性||[1]||
AITD-00314|Contrastive Divergence|对比散度||[1]||
AITD-00316|Convergence|收敛||[1]||
AITD-00318|Convex Optimization|凸优化||[[1]](https://www.jiqizhixin.com/articles/2017-12-29-4)||
AITD-00319|Convex Quadratic Programming|凸二次规划||[1]||
AITD-00322|Convolution|卷积||[1]||
AITD-00325|Convolutional Kernel|卷积核||[1]||
AITD-00327|Convolutional Neural Network|卷积神经网络|CNN|[[1]](https://www.jiqizhixin.com/articles/2017-12-19-8)[[2]](https://www.jiqizhixin.com/articles/2018-01-08-6)[[3]](https://www.jiqizhixin.com/articles/2017-12-18-2)||
AITD-00330|Coordinate Descent|坐标下降||[1]||
AITD-00332|Corpus|语料库||[1]||
AITD-00334|Correlation Coefficient|相关系数||[1]||
AITD-00337|Cosine Similarity|余弦相似度||[1]||
AITD-00338|Cost|代价||[1]||
AITD-00339|Cost Curve|代价曲线||[1]||
AITD-00340|Cost Function|代价函数||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)||
AITD-00341|Cost Matrix|代价矩阵||[1]||
AITD-00342|Cost-Sensitive|代价敏感||[1]||
AITD-00343|Covariance|协方差||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00344|Covariance Matrix|协方差矩阵||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00352|Critical Point|临界点||[1]||
AITD-00355|Cross Entropy|交叉熵||[1]||
AITD-00356|Cross Validation|交叉验证||[[1]](https://www.jiqizhixin.com/articles/2017-10-16-4)||
AITD-00362|Curse of Dimensionality|维数灾难||[1]||
AITD-00366|Cutting Plane Algorithm|割平面法||[1]||
AITD-00376|Data Mining|数据挖掘||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00380|Data Set|数据集||[[1]](https://www.jiqizhixin.com/articles/2018-01-04-6)[[2]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-00383|Davidon-Fletcher-Powell|DFP||[1]||
AITD-00385|Decision Boundary|决策边界||[1]||
AITD-00386|Decision Function|决策函数||[1]||
AITD-00387|Decision Stump|决策树桩||[1]||
AITD-00389|Decision Tree|决策树|DT|[[1]](https://www.jiqizhixin.com/articles/2018-01-10)[[2]](https://www.jiqizhixin.com/articles/2017-11-29-5)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00390|Decoder|解码器||[1]||
AITD-00391|Decoding|解码||[1]||
AITD-00393|Deconvolution|反卷积||[1]||
AITD-00394|Deconvolutional Network|反卷积网络||[[1]](https://www.jiqizhixin.com/articles/2017-09-14)||
AITD-00395|Deduction|演绎||[1]||
AITD-00396|Deep Belief Network|深度信念网络|DBN|[1]||
AITD-00397|Deep Boltzmann Machine|深度玻尔兹曼机|DBM|[1]||
AITD-00399|Deep Convolutional Generative Adversarial Network|深度卷积生成对抗网络|DCGAN|[1]||
AITD-00402|Deep Learning|深度学习|DL|[[1]](https://www.jiqizhixin.com/articles/2018-01-17-2)[[2]](https://www.jiqizhixin.com/articles/2018-01-15-4)[[3]](https://www.jiqizhixin.com/articles/2018-01-15-2)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[5]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-00405|Deep Neural Network|深度神经网络|DNN|[[1]](https://www.jiqizhixin.com/articles/2018-01-15-2)[[2]](https://www.jiqizhixin.com/articles/2018-01-10)[[3]](https://www.jiqizhixin.com/articles/2018-01-07-2)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[5]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)[[6]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[7]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)||
AITD-00407|Deep Q-Network|深度Q网络|DQN|[1]||
AITD-00413|Delta-Bar-Delta|Delta-Bar-Delta||[1]||
AITD-00414|Denoising|去噪||[1]||
AITD-00415|Denoising Autoencoder|去噪自编码器||[1]||
AITD-00416|Denoising Score Matching|去躁分数匹配||[1]||
AITD-00419|Density Estimation|密度估计||[1]||
AITD-00420|Density-Based Clustering|密度聚类||[1]||
AITD-00423|Derivative|导数||[1]||
AITD-00429|Determinant|行列式||[1]||
AITD-00434|Diagonal Matrix|对角矩阵||[1]||
AITD-00437|Dictionary Learning|字典学习||[1]||
AITD-00445|Dimension Reduction|降维||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00451|Directed Edge|有向边||[1]||
AITD-00453|Directed Graphical Model|有向图模型||[1]||
AITD-00455|Directed Separation|有向分离||[1]||
AITD-00457|Dirichlet Distribution|狄利克雷分布||[1]||
AITD-00465|Discriminative Model|判别式模型||[1]||
AITD-00467|Discriminator|判别器||[1]||
AITD-00468|Discriminator Network|判别网络||[1]||
AITD-00470|Distance Measure|距离度量||[1]||
AITD-00471|Distance Metric Learning|距离度量学习||[1]||
AITD-00472|Distributed Representation|分布式表示||[1]||
AITD-00474|Diverge|发散||[1]||
AITD-00475|Divergence|散度||[1]||
AITD-00476|Diversity|多样性||[1]||
AITD-00477|Diversity Measure|多样性度量/差异性度量||[1]||
AITD-00481|Domain Adaptation|领域自适应||[1]||
AITD-00482|Dominant Eigenvalue|主特征值||[1]||
AITD-00485|Dominant Strategy|占优策略||[1]||
AITD-00489|Down Sampling|下采样||[1]||
AITD-00491|Dropout|暂退法||[1]||
AITD-00492|Dropout Boosting|暂退Boosting||[1]||
AITD-00494|Dropout Method|暂退法||[1]||
AITD-00496|Dual Problem|对偶问题||[1]||
AITD-00497|Dummy Node|哑结点||[1]||
AITD-00499|Dynamic Bayesian Network|动态贝叶斯网络||[1]||
AITD-00502|Dynamic Programming|动态规划||[1]||
AITD-00506|Early Stopping|早停||[1]||
AITD-00512|Eigendecomposition|特征分解||[[1]](https://www.jiqizhixin.com/articles/2017-07-05-2)||
AITD-00513|Eigenvalue|特征值||[1]||
AITD-00517|Element-Wise Product|逐元素积||[1]||
AITD-00520|Embedding|嵌入||[[1]](https://www.jiqizhixin.com/articles/2018-01-02-5)||
AITD-00523|Empirical Conditional Entropy|经验条件熵||[1]||
AITD-00524|Empirical Distribution|经验分布||[1]||
AITD-00525|Empirical Entropy|经验熵||[1]||
AITD-00526|Empirical Error|经验误差||[1]||
AITD-00529|Empirical Risk|经验风险||[1]||
AITD-00530|Empirical Risk Minimization|经验风险最小化|ERM|[1]||
AITD-00531|Encoder|编码器||[1]||
AITD-00533|Encoding|编码||[1]||
AITD-00534|End-To-End|端到端||[[1]](https://www.jiqizhixin.com/articles/2017-12-15)||
AITD-00537|Energy Function|能量函数||[1]||
AITD-00539|Energy-Based Model|基于能量的模型||[1]||
AITD-00541|Ensemble Learning|集成学习||[[1]](https://www.jiqizhixin.com/articles/2018-01-14-8)||
AITD-00542|Ensemble Pruning|集成修剪||[1]||
AITD-00543|Entropy|熵||[1]||
AITD-00546|Episode|回合||[1]||
AITD-00548|Epoch|轮||[1]||
AITD-00554|Error|误差||[1]||
AITD-00555|Error Backpropagation Algorithm|误差反向传播算法||[1]||
AITD-00556|Error Backpropagation|误差反向传播||[1]||
AITD-00558|Error Correcting Output Codes|纠错输出编码|ECOC|[1]||
AITD-00561|Error Rate|错误率||[1]||
AITD-00562|Error-Ambiguity Decomposition|误差－分歧分解||[1]||
AITD-00565|Estimator|估计/估计量||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)||
AITD-00566|Euclidean Distance|欧氏距离||[1]||
AITD-00571|Evidence|证据||[1]||
AITD-00572|Evidence Lower Bound|证据下界|ELBO|[1]||
AITD-00576|Exact Inference|精确推断||[1]||
AITD-00577|Example|样例||[1]||
AITD-00580|Expectation|期望||[1]||
AITD-00582|Expectation Maximization|期望最大化|EM|[1]||
AITD-00585|Expected Loss|期望损失||[1]||
AITD-00592|Expert System|专家系统||[1]||
AITD-00597|Exploding Gradient|梯度爆炸||[1]||
AITD-00605|Exponential Loss Function|指数损失函数||[1]||
AITD-00612|Factor|因子||[1]||
AITD-00616|Factorization|因子分解||[1]||
AITD-00626|Feature|特征||[1]||
AITD-00627|Feature Engineering|特征工程||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)||
AITD-00631|Feature Map|特征图||[1]||
AITD-00633|Feature Selection|特征选择||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)||
AITD-00635|Feature Vector|特征向量||[1]||
AITD-00636|Featured Learning|特征学习||[1]||
AITD-00638|Feedforward|前馈||[1]||
AITD-00641|Feedforward Neural Network|前馈神经网络|FNN|[[1]](https://www.jiqizhixin.com/articles/2017-09-07-9)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)||
AITD-00642|Few-Shot Learning|少试学习||[1]||
AITD-00645|Filter|滤波器||[1]||
AITD-00647|Fine-Tuning|微调||[1]||
AITD-00659|Fluctuation|振荡||[1]||
AITD-00662|Forget Gate|遗忘门||[1]||
AITD-00666|Forward Propagation|前向传播/正向传播||[1]||
AITD-00668|Forward Stagewise Algorithm|前向分步算法||[1]||
AITD-00672|Fractionally Strided Convolution|微步卷积||[1]||
AITD-00677|Frobenius Norm|Frobenius 范数||[1]||
AITD-00681|Full Padding|全填充||[1]||
AITD-00688|Functional|泛函||[1]||
AITD-00691|Functional Neuron|功能神经元||[1]||
AITD-00702|Gated Recurrent Unit|门控循环单元|GRU|[1]||
AITD-00703|Gated RNN|门控RNN||[1]||
AITD-00706|Gaussian Distribution|高斯分布||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)||
AITD-00708|Gaussian Kernel|高斯核||[1]||
AITD-00709|Gaussian Kernel Function|高斯核函数||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)||
AITD-00710|Gaussian Mixture Model|高斯混合模型|GMM|[1]||
AITD-00713|Gaussian Process|高斯过程|GP|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-00719|Generalization Ability|泛化能力||[1]||
AITD-00720|Generalization Error|泛化误差||[1]||
AITD-00721|Generalization Error Bound|泛化误差上界||[1]||
AITD-00722|Generalize|泛化||[[1]](https://www.jiqizhixin.com/articles/2017-12-25-10)||
AITD-00726|Generalized Lagrange Function|广义拉格朗日函数||[1]||
AITD-00728|Generalized Linear Model|广义线性模型||[1]||
AITD-00731|Generalized Rayleigh Quotient|广义瑞利商||[1]||
AITD-00734|Generative Adversarial Network|生成对抗网络||[[1]](https://www.jiqizhixin.com/articles/2017-12-26-4)[[2]](https://www.jiqizhixin.com/articles/2018-01-08-5)[[3]](https://www.jiqizhixin.com/articles/2017-12-13-2)||
AITD-00736|Generative Model|生成式模型||[[1]](https://www.jiqizhixin.com/articles/2017-12-19-7)[[2]](https://www.jiqizhixin.com/articles/2017-12-11-6)[[3]](https://www.jiqizhixin.com/articles/2017-12-04-5)||
AITD-00742|Generator|生成器||[1]||
AITD-00743|Generator Network|生成器网络||[1]||
AITD-00744|Genetic Algorithm|遗传算法|GA|[[1]](https://www.jiqizhixin.com/articles/2018-01-17-3)[[2]](https://www.jiqizhixin.com/articles/2017-12-22)[[3]](https://www.jiqizhixin.com/articles/2017-11-12-2)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[5]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)[[6]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)|机器学习|
AITD-00747|Gibbs Distribution|吉布斯分布||[1]||
AITD-00748|Gibbs Sampling|吉布斯采样/吉布斯抽样||[1]||
AITD-00750|Gini Index|基尼指数||[1]||
AITD-00752|Global Markov Property|全局马尔可夫性||[1]||
AITD-00755|Global Minimum|全局最小||[1]||
AITD-00757|Gradient|梯度||[1]||
AITD-00762|Gradient Clipping|梯度截断||[1]||
AITD-00763|Gradient Descent|梯度下降||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|机器学习|
AITD-00765|Gradient Descent Method|梯度下降法||[1]||
AITD-00768|Gradient Exploding Problem|梯度爆炸问题||[[1]](https://www.jiqizhixin.com/articles/2017-12-21-14)||
AITD-00771|Gram Matrix|Gram 矩阵||[1]||
AITD-00775|Graph Convolutional Network|图卷积神经网络/图卷积网络|GCN|[1]||
AITD-00776|Graph Neural Network|图神经网络|GNN|[1]||
AITD-00778|Graphical Model|图模型|GM|[1]||
AITD-00788|Grid Search|网格搜索||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)||
AITD-00790|Ground Truth|真实值||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)||
AITD-00792|Hadamard Product|Hadamard积||[1]||
AITD-00793|Hamming Distance|汉明距离||[1]||
AITD-00796|Hard Margin|硬间隔||[1]||
AITD-00807|Hebbian Rule|赫布法则||[1]||
AITD-00816|Hidden Layer|隐藏层||[1]||
AITD-00817|Hidden Markov Model|隐马尔可夫模型|HMM|[[1]](https://www.jiqizhixin.com/articles/2017-09-21-8)||
AITD-00820|Hidden Variable|隐变量||[1]||
AITD-00821|Hierarchical Clustering|层次聚类||[1]||
AITD-00824|Hilbert Space|希尔伯特空间||[1]||
AITD-00826|Hinge Loss Function|合页损失函数/Hinge损失函数||[1]||
AITD-00828|Hold-Out|留出法||[1]||
AITD-00834|Hyperparameter|超参数||[[1]](https://www.jiqizhixin.com/articles/2017-08-18-5)[[2]](https://www.jiqizhixin.com/articles/2017-11-28)||
AITD-00835|Hyperparameter Optimization|超参数优化||[1]||
AITD-00837|Hypothesis|假设||[1]||
AITD-00838|Hypothesis Space|假设空间||[1]||
AITD-00839|Hypothesis Test|假设检验||[1]||
AITD-00845|Identity Matrix|单位矩阵||[1]||
AITD-00850|Imitation Learning|模仿学习||[1]||
AITD-00855|Importance Sampling|重要性采样||[1]||
AITD-00856|Improved Iterative Scaling|改进的迭代尺度法|IIS|[1]||
AITD-00858|Incremental Learning|增量学习||[1]||
AITD-00862|Independent and Identically Distributed|独立同分布|I.I.D.|[1]||
AITD-00866|Indicator Function|指示函数||[1]||
AITD-00867|Individual Learner|个体学习器||[1]||
AITD-00868|Induction|归纳||[1]||
AITD-00869|Inductive Bias|归纳偏好||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)||
AITD-00870|Inductive Learning|归纳学习||[1]||
AITD-00871|Inductive Logic Programming|归纳逻辑程序设计|ILP|[1]||
AITD-00874|Inference|推断||[[1]](https://www.jiqizhixin.com/articles/2017-12-14-6)||
AITD-00878|Information Entropy|信息熵||[1]||
AITD-00879|Information Gain|信息增益||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|统计|
AITD-00883|Inner Product|内积||[1]||
AITD-00890|Instance|示例||[1]||
AITD-00896|Internal Covariate Shift|内部协变量偏移||[1]||
AITD-00905|Inverse Matrix|逆矩阵||[1]||
AITD-00907|Inverse Resolution|逆归结||[1]||
AITD-00912|Isometric Mapping|等度量映射|Isomap|[1]||
AITD-00919|Jacobian Matrix|雅可比矩阵||[1]||
AITD-00920|Jensen Inequality|Jensen不等式||[1]||
AITD-00923|Joint Probability Distribution|联合概率分布||[1]||
AITD-00925|K-Armed Bandit Problem|k-摇臂老虎机||[1]||
AITD-00926|K-Fold Cross Validation|k 折交叉验证|K-FOLD CV|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|统计|
AITD-00930|Karush-Kuhn-Tucker Condition|KKT条件||[1]||
AITD-00931|Karush–Kuhn–Tucker|Karush–Kuhn–Tucker||[1]||
AITD-00934|Kernel Function|核函数||[1]||
AITD-00937|Kernel Method|核方法||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)|机器学习|
AITD-00939|Kernel Trick|核技巧||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00941|Kernelized Linear Discriminant Analysis|核线性判别分析|KLDA |[1]||
AITD-00944|KL Divergence|KL散度||[1]||
AITD-00953|L-BFGS|L-BFGS||[1]||
AITD-00954|Label|标签/标记||[1]||
AITD-00957|Label Space|标记空间||[1]||
AITD-00960|Lagrange Duality|拉格朗日对偶性||[1]||
AITD-00962|Lagrange Multiplier|拉格朗日乘子||[1]||
AITD-00963|Language Model|语言模型||[1]||
AITD-00966|Laplace Smoothing|拉普拉斯平滑||[1]||
AITD-00967|Laplacian Correction|拉普拉斯修正||[1]||
AITD-00971|Latent Dirichlet Allocation|潜在狄利克雷分配|LDA|[[1]](https://www.jiqizhixin.com/articles/2017-09-01-7)||
AITD-00973|Latent Semantic Analysis|潜在语义分析|LSA|[1]||
AITD-00975|Latent Variable|潜变量/隐变量||[1]||
AITD-00976|Law of Large Numbers|大数定律||[1]||
AITD-00978|Layer Normalization|层规范化||[1]||
AITD-00984|Lazy Learning|懒惰学习||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00987|Leaky Relu|泄漏修正线性单元/泄漏整流线性单元||[1]||
AITD-00991|Learner|学习器||[1]||
AITD-00992|Learning|学习||[1]||
AITD-00994|Learning By Analogy|类比学习||[1]||
AITD-00995|Learning Rate|学习率||[1]||
AITD-01000|Learning Vector Quantization|学习向量量化|LVQ|[1]||
AITD-01003|Least Square Method|最小二乘法|LSM|[[1]](https://www.jiqizhixin.com/articles/2017-09-24-5)||
AITD-01004|Least Squares Regression Tree|最小二乘回归树||[1]||
AITD-01009|Left Singular Vector|左奇异向量||[1]||
AITD-01012|Likelihood|似然||[1]||
AITD-01016|Linear Chain Conditional Random Field|线性链条件随机场||[1]||
AITD-01017|Linear Classification Model|线性分类模型||[1]||
AITD-01018|Linear Classifier|线性分类器||[1]||
AITD-01020|Linear Dependence|线性相关||[1]||
AITD-01021|Linear Discriminant Analysis|线性判别分析|LDA|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)|统计、机器学习|
AITD-01024|Linear Model|线性模型|LR|[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)|统计、机器学习|
AITD-01026|Linear Regression|线性回归||[[1]](https://www.jiqizhixin.com/articles/2018-01-01)[[2]](https://www.jiqizhixin.com/articles/2017-11-17-5)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|统计、数学|
AITD-01038|Link Function|联系函数||[1]||
AITD-01054|Local Markov Property|局部马尔可夫性||[1]||
AITD-01057|Local Minima|局部极小||[1]||
AITD-01059|Local Minimum|局部极小||[1]||
AITD-01060|Local Representation|局部式表示/局部式表征||[1]||
AITD-01063|Log Likelihood|对数似然函数||[1]||
AITD-01064|Log Linear Model|对数线性模型||[1]||
AITD-01065|Log-Likelihood|对数似然||[1]||
AITD-01067|Log-Linear Regression|对数线性回归||[1]||
AITD-01071|Logistic Function|对数几率函数||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00398/978-1-78801-789-3)||
AITD-01073|Logistic Regression|对数几率回归|LR|[[1]](https://www.jiqizhixin.com/articles/2017-11-23-6)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)|统计、机器学习|
AITD-01075|Logit|对数几率||[1]||
AITD-01076|Long Short Term Memory|长短期记忆|LSTM|[[1]](https://www.jiqizhixin.com/articles/2017-12-18-6)[[2]](https://www.jiqizhixin.com/articles/2017-10-04-2)[[3]](https://www.jiqizhixin.com/articles/2017-09-29-7)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)||
AITD-01077|Long Short-Term Memory Network|长短期记忆网络|LSTM|[1]||
AITD-01082|Loopy Belief Propagation|环状信念传播|LBP|[1]||
AITD-01084|Loss Function|损失函数||[[1]](https://www.jiqizhixin.com/articles/2018-01-03-4)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)|机器学习|
AITD-01085|Low Rank Matrix Approximation|低秩矩阵近似||[1]||
AITD-01088|Machine Learning|机器学习|ML|[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-01093|Macron-R|宏查全率||[1]||
AITD-01098|Manhattan Distance|曼哈顿距离||[1]||
AITD-01099|Manifold|流形||[1]||
AITD-01100|Manifold Assumption|流形假设||[1]||
AITD-01101|Manifold Learning|流形学习||[1]||
AITD-01103|Margin|间隔||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|统计|
AITD-01105|Marginal Distribution|边缘分布||[1]||
AITD-01106|Marginal Independence|边缘独立性||[1]||
AITD-01109|Marginalization|边缘化||[1]||
AITD-01111|Markov Chain|马尔可夫链||[1]||
AITD-01112|Markov Chain Monte Carlo|马尔可夫链蒙特卡罗|MCMC|[[1]](https://www.jiqizhixin.com/articles/2017-12-24-6)||
AITD-01113|Markov Decision Process|马尔可夫决策过程|MDP|[1]||
AITD-01114|Markov Network|马尔可夫网络||[1]||
AITD-01115|Markov Process|马尔可夫过程||[1]||
AITD-01117|Markov Random Field|马尔可夫随机场|MRF|[1]||
AITD-01118|Mask|掩码||[1]||
AITD-01122|Matrix|矩阵||[1]||
AITD-01126|Matrix Inversion|逆矩阵||[1]||
AITD-01129|Max Pooling|最大汇聚||[[1]](https://www.jiqizhixin.com/articles/2017-10-02-5)||
AITD-01131|Maximal Clique|最大团||[1]||
AITD-01137|Maximum Entropy Model|最大熵模型||[1]||
AITD-01139|Maximum Likelihood Estimation|极大似然估计|MLE|[[1]](https://www.jiqizhixin.com/articles/2018-01-09-6)||
AITD-01141|Maximum Margin|最大间隔||[1]||
AITD-01150|Mean Filed|平均场||[1]||
AITD-01152|Mean Pooling|平均汇聚||[1]||
AITD-01154|Mean Squared Error|均方误差||[1]||
AITD-01156|Mean-Field|平均场||[1]||
AITD-01165|Memory Network|记忆网络|MN|[1]||
AITD-01169|Message Passing|消息传递||[1]||
AITD-01176|Metric Learning|度量学习||[1]||
AITD-01180|Micro-R|微查全率||[1]||
AITD-01185|Minibatch|小批量||[1]||
AITD-01188|Minimal Description Length|最小描述长度|MDL|[1]||
AITD-01189|Minimax Game|极小极大博弈||[1]||
AITD-01191|Minkowski Distance|闵可夫斯基距离||[1]||
AITD-01197|Mixture of Experts|混合专家模型||[1]||
AITD-01198|Mixture-of-Gaussian|高斯混合||[1]||
AITD-01201|Model|模型||[1]||
AITD-01210|Model Selection|模型选择||[[1]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-01219|Momentum Method|动量法||[1]||
AITD-01223|Monte Carlo Method|蒙特卡罗方法||[1]||
AITD-01226|Moral Graph|端正图/道德图||[1]||
AITD-01227|Moralization|道德化||[1]||
AITD-01231|Multi-Class Classification|多分类||[1]||
AITD-01234|Multi-Head Attention|多头注意力||[1]||
AITD-01235|Multi-Head Self-Attention|多头自注意力||[1]||
AITD-01237|Multi-Kernel Learning|多核学习||[1]||
AITD-01239|Multi-Label Learning|多标记学习||[1]||
AITD-01240|Multi-Layer Feedforward Neural Networks|多层前馈神经网络||[1]||
AITD-01241|Multi-Layer Perceptron|多层感知机|MLP|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00398/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)||
AITD-01249|Multinomial Distribution|多项分布||[1]||
AITD-01252|Multiple Dimensional Scaling|多维缩放||[1]||
AITD-01253|Multiple Linear Regression|多元线性回归|MLR|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)|统计|
AITD-01254|Multitask Learning|多任务学习||[1]||
AITD-01257|Multivariate Normal Distribution|多元正态分布||[1]||
AITD-01258|Mutual Information|互信息||[1]||
AITD-01261|N-Gram Model|N元模型||[1]||
AITD-01263|Naive Bayes Classifier|朴素贝叶斯分类器||[1]||
AITD-01264|Naive Bayes|朴素贝叶斯|NB|[[1]](https://www.jiqizhixin.com/articles/2017-11-20-6)||
AITD-01274|Nearest Neighbor Classifier|最近邻分类器||[1]||
AITD-01281|Negative Log Likelihood|负对数似然函数||[1]||
AITD-01287|Neighbourhood Component Analysis|近邻成分分析|NCA|[1]||
AITD-01291|Net Input|净输入||[1]||
AITD-01300|Neural Network|神经网络|NN|[1]||
AITD-01301|Neural Turing Machine|神经图灵机|NTM|[[1]](https://www.jiqizhixin.com/articles/2017-04-11-7)||
AITD-01304|Neuron|神经元||[1]||
AITD-01305|Newton Method|牛顿法||[[1]](https://www.jiqizhixin.com/articles/2017-03-11-2)||
AITD-01306|No Free Lunch Theorem|没有免费午餐定理|NFL|[[1]](https://www.jiqizhixin.com/articles/2018-01-03-6)||
AITD-01310|Noise-Contrastive Estimation|噪声对比估计|NCE|[1]||
AITD-01311|Nominal Attribute|列名属性||[1]||
AITD-01313|Non-Convex Optimization|非凸优化||[[1]](https://www.jiqizhixin.com/articles/2017-12-29-4)||
AITD-01318|Non-Metric Distance|非度量距离||[1]||
AITD-01319|Non-Negative Matrix Factorization|非负矩阵分解|NMF|[1]||
AITD-01320|Non-Ordinal Attribute|无序属性||[1]||
AITD-01334|Norm|范数||[1]||
AITD-01336|Normal Distribution|正态分布||[1]||
AITD-01338|Normalization|规范化||[[1]](https://www.nature.com/articles/s41557-021-00716-z)|统计、机器学习|
AITD-01342|Nuclear Norm|核范数||[1]||
AITD-01344|Number of Epochs|轮数||[1]||
AITD-01347|Numerical Attribute|数值属性||[1]||
AITD-01351|Object Detection|目标检测||[1]||
AITD-01355|Oblique Decision Tree|斜决策树||[1]||
AITD-01358|Occam's Razor|奥卡姆剃刀||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-01359|Odds|几率||[1]||
AITD-01360|Off-Policy|异策略||[1]||
AITD-01364|On-Policy|同策略||[1]||
AITD-01365|One-Shot Learning|单试学习||[[1]](https://www.jiqizhixin.com/articles/2017-03-13-2)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)||
AITD-01366|One-Dependent Estimator|独依赖估计|ODE|[1]||
AITD-01367|One-Hot|独热||[1]||
AITD-01370|Online Learning|在线学习||[1]||
AITD-01376|Optimizer|优化器||[1]||
AITD-01378|Ordinal Attribute|有序属性||[1]||
AITD-01380|Orthogonal|正交||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|数学|
AITD-01382|Orthogonal Matrix|正交矩阵||[1]||
AITD-01384|Out-Of-Bag Estimate|包外估计||[1]||
AITD-01386|Outlier|异常点||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-01392|Over-Parameterized|过度参数化||[1]||
AITD-01395|Overfitting|过拟合||[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|机器学习|
AITD-01398|Oversampling|过采样||[1]||
AITD-01400|Pac-Learnable|PAC可学习||[1]||
AITD-01401|Padding|填充||[1]||
AITD-01404|Pairwise Markov Property|成对马尔可夫性||[1]||
AITD-01405|Parallel Distributed Processing|分布式并行处理|PDP|[1]||
AITD-01407|Parameter|参数||[1]||
AITD-01408|Parameter Estimation|参数估计||[1]||
AITD-01411|Parameter Space|参数空间||[1]||
AITD-01412|Parameter Tuning|调参||[[1]](https://www.jiqizhixin.com/articles/2018-01-03-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)|机器学习|
AITD-01416|Parametric ReLU|参数化修正线性单元/参数化整流线性单元|PReLU|[1]||
AITD-01418|Part-Of-Speech Tagging|词性标注||[1]||
AITD-01419|Partial Derivative|偏导数||[1]||
AITD-01420|Partially Observable Markov Decision Processes|部分可观测马尔可夫决策过程|POMDP|[1]||
AITD-01423|Partition Function|配分函数||[1]||
AITD-01428|Perceptron|感知机||[[1]](https://www.jiqizhixin.com/articles/2018-01-15-2)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)|机器学习|
AITD-01429|Performance Measure|性能度量||[1]||
AITD-01432|Perplexity|困惑度||[1]||
AITD-01444|Pointer Network|指针网络||[1]||
AITD-01446|Policy|策略||[1]||
AITD-01448|Policy Gradient|策略梯度||[1]||
AITD-01450|Policy Iteration|策略迭代||[1]||
AITD-01453|Polynomial Kernel Function|多项式核函数||[1]||
AITD-01456|Pooling|汇聚||[[1]](https://www.jiqizhixin.com/articles/2017-10-02-5)||
AITD-01458|Pooling Layer|汇聚层||[1]||
AITD-01465|Positive Definite Matrix|正定矩阵||[1]||
AITD-01473|Post-Pruning|后剪枝||[1]||
AITD-01477|Potential Function|势函数||[1]||
AITD-01478|Power Method|幂法||[1]||
AITD-01481|Pre-Training|预训练||[1]||
AITD-01482|Precision|查准率/准确率||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|数学、HPC|
AITD-01485|Prepruning|预剪枝||[1]||
AITD-01487|Primal Problem|主问题||[1]||
AITD-01488|Primary Visual Cortex|初级视觉皮层||[1]||
AITD-01489|Principal Component Analysis|主成分分析|PCA|[[1]](https://www.jiqizhixin.com/articles/2017-12-03-4)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)||
AITD-01491|Prior|先验||[1]||
AITD-01498|Probabilistic Context-Free Grammar|概率上下文无关文法||[1]||
AITD-01501|Probabilistic Graphical Model|概率图模型|PGM|[[1]](https://www.jiqizhixin.com/articles/2017-11-29-3)||
AITD-01504|Probabilistic Model|概率模型||[1]||
AITD-01508|Probability Density Function|概率密度函数|PDF|[1]||
AITD-01509|Probability Distribution|概率分布||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00195/978-1-83916-023-3)|统计|
AITD-01512|Probably Approximately Correct|概率近似正确|PAC|[1]||
AITD-01517|Proposal Distribution|提议分布||[1]||
AITD-01520|Prototype-Based Clustering|原型聚类||[1]||
AITD-01521|Proximal Gradient Descent|近端梯度下降|PGD|[1]||
AITD-01522|Pruning|剪枝||[[1]](https://www.jiqizhixin.com/articles/2017-09-26)||
AITD-01528|Quadratic Loss Function|平方损失函数||[1]||
AITD-01529|Quadratic Programming|二次规划||[1]||
AITD-01536|Quasi Newton Method|拟牛顿法||[[1]](https://www.jiqizhixin.com/articles/2017-12-16-3)||
AITD-01541|Radial Basis Function|径向基函数|RBF|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00398/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)||
AITD-01545|Random Forest|随机森林|RF、RFS|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00251/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)[[4]](https://www.nature.com/articles/s41557-021-00716-z)[[5]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)|统计|
AITD-01547|Random Sampling|随机采样||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)|统计|
AITD-01548|Random Search|随机搜索||[1]||
AITD-01550|Random Variable|随机变量||[1]||
AITD-01551|Random Walk|随机游走||[1]||
AITD-01561|Recall|查全率/召回率||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)||
AITD-01564|Receptive Field|感受野||[1]||
AITD-01569|Reconstruction Error|重构误差||[1]||
AITD-01573|Rectified Linear Unit|修正线性单元/整流线性单元|ReLU|[[1]](https://www.jiqizhixin.com/articles/2017-10-21-4)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|CHAPTER 2|
AITD-01579|Recurrent Neural Network|循环神经网络|RNN|[[1]](https://www.jiqizhixin.com/articles/2018-01-13-4)[[2]](https://www.jiqizhixin.com/articles/2018-01-05-5)[[3]](https://www.jiqizhixin.com/articles/2017-12-21-15)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)[[5]](https://www.nature.com/articles/s41557-021-00716-z)[[6]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|机器学习|
AITD-01580|Recursive Neural Network|递归神经网络|RecNN|[1]||
AITD-01585|Regression|回归||[[1]](https://www.jiqizhixin.com/articles/2017-12-21-13)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[3]](https://www.nature.com/articles/s41557-021-00716-z)|统计|
AITD-01586|Regularization|正则化||[[1]](https://www.jiqizhixin.com/articles/2017-12-20)||
AITD-01587|Regularizer|正则化项||[1]||
AITD-01588|Reinforcement Learning|强化学习|RL|[[1]](https://www.jiqizhixin.com/articles/2018-01-17-3)[[2]](https://www.jiqizhixin.com/articles/2017-12-28-6)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)[[5]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)|机器学习|
AITD-01592|Relative Entropy|相对熵||[1]||
AITD-01594|Reparameterization|再参数化/重参数化||[1]||
AITD-01597|Representation|表示||[1]||
AITD-01598|Representation Learning|表示学习||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)||
AITD-01600|Representer Theorem|表示定理||[1]||
AITD-01601|Reproducing Kernel Hilbert Space|再生核希尔伯特空间|RKHS|[1]||
AITD-01602|Rescaling|再缩放||[1]||
AITD-01604|Reset Gate|重置门||[1]||
AITD-01606|Residual Connection|残差连接||[1]||
AITD-01608|Residual Network|残差网络|ResNet|[[1]](https://www.jiqizhixin.com/articles/2017-12-18-2)||
AITD-01612|Restricted Boltzmann Machine|受限玻尔兹曼机|RBM|[[1]](https://www.jiqizhixin.com/articles/2017-10-08-4)||
AITD-01619|Reward|奖励||[1]||
AITD-01621|Ridge Regression|岭回归||[1]||
AITD-01624|Right Singular Vector|右奇异向量||[1]||
AITD-01625|Risk|风险||[1]||
AITD-01627|Robustness|稳健性||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|计算机、机器学习|
AITD-01628|Root Node|根结点||[1]||
AITD-01632|Rule Learning|规则学习||[1]||
AITD-01635|Saddle Point|鞍点||[[1]](https://www.jiqizhixin.com/articles/2017-09-08)||
AITD-01640|Sample|样本||[1]||
AITD-01641|Sample Complexity|样本复杂度||[1]||
AITD-01643|Sample Space|样本空间||[1]||
AITD-01649|Scalar|标量||[1]||
AITD-01661|Selective Ensemble|选择性集成||[1]||
AITD-01662|Self Information|自信息||[1]||
AITD-01663|Self-Attention|自注意力||[1]||
AITD-01668|Self-Organizing Map|自组织映射网|SOM|[1]||
AITD-01670|Self-Training|自训练||[1]||
AITD-01675|Semi-Definite Programming|半正定规划||[1]||
AITD-01676|Semi-Naive Bayes Classifiers|半朴素贝叶斯分类器||[1]||
AITD-01677|Semi-Restricted Boltzmann Machine|半受限玻尔兹曼机||[1]||
AITD-01679|Semi-Supervised Clustering|半监督聚类||[1]||
AITD-01680|Semi-Supervised Learning|半监督学习||[[1]](https://www.jiqizhixin.com/articles/2017-12-22-3)[[2]](https://www.jiqizhixin.com/articles/2017-12-02)[[3]](https://www.jiqizhixin.com/articles/2018-01-07)||
AITD-01681|Semi-Supervised Support Vector Machine|半监督支持向量机|S3VM|[1]||
AITD-01682|Sentiment Analysis|情感分析||[[1]](https://www.jiqizhixin.com/articles/2017-12-07-7)||
AITD-01685|Separating Hyperplane|分离超平面||[1]||
AITD-01690|Sequential Covering|序贯覆盖||[1]||
AITD-01708|Sigmoid Belief Network|Sigmoid信念网络|SBN|[1]||
AITD-01710|Sigmoid Function|Sigmoid函数||[[1]](https://www.jiqizhixin.com/articles/2017-11-02-26)||
AITD-01712|Signed Distance|带符号距离||[1]||
AITD-01714|Similarity Measure|相似度度量||[1]||
AITD-01719|Simulated Annealing|模拟退火||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)|统计、机器学习|
AITD-01720|Simultaneous Localization And Mapping|即时定位与地图构建|SLAM|[1]||
AITD-01724|Singular Value|奇异值||[1]||
AITD-01725|Singular Value Decomposition|奇异值分解|SVD|[1]||
AITD-01729|Skip-Gram Model|跳元模型||[1]||
AITD-01734|Smoothing|平滑||[1]||
AITD-01738|Soft Margin|软间隔||[1]||
AITD-01739|Soft Margin Maximization|软间隔最大化||[1]||
AITD-01742|Softmax|Softmax/软最大化||[1]||
AITD-01743|Softmax Function|Softmax函数/软最大化函数||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00398/978-1-78801-789-3)|统计、机器学习|
AITD-01744|Softmax Regression|Softmax回归/软最大化回归||[1]||
AITD-01747|Softplus Function|Softplus函数||[1]||
AITD-01749|Span|张成子空间||[1]||
AITD-01753|Sparse Coding|稀疏编码||[1]||
AITD-01757|Sparse Representation|稀疏表示||[1]||
AITD-01759|Sparsity|稀疏性||[1]||
AITD-01760|Specialization|特化||[1]||
AITD-01769|Splitting Variable|切分变量||[1]||
AITD-01775|Squashing Function|挤压函数||[1]||
AITD-01785|Standard Normal Distribution|标准正态分布||[1]||
AITD-01787|State|状态||[1]||
AITD-01791|State Value Function|状态值函数||[1]||
AITD-01792|State-Action Value Function|状态-动作值函数||[1]||
AITD-01797|Stationary Distribution|平稳分布||[1]||
AITD-01798|Stationary Point|驻点||[1]||
AITD-01800|Statistical Learning|统计学习||[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)||
AITD-01807|Steepest Descent|最速下降法||[1]||
AITD-01813|Stochastic Gradient Descent|随机梯度下降||[[1]](https://www.jiqizhixin.com/articles/2017-12-25-10)||
AITD-01815|Stochastic Matrix|随机矩阵||[1]||
AITD-01820|Stochastic Process|随机过程||[1]||
AITD-01822|Stratified Sampling|分层采样||[1]||
AITD-01824|Stride|步幅||[1]||
AITD-01830|Structural Risk|结构风险||[1]||
AITD-01831|Structural Risk Minimization|结构风险最小化|SRM|[1]||
AITD-01839|Subsample|子采样||[1]||
AITD-01840|Subsampling|下采样||[1]||
AITD-01843|Subset Search|子集搜索||[1]||
AITD-01844|Subspace|子空间||[1]||
AITD-01852|Supervised Learning|监督学习||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|机器学习|
AITD-01856|Support Vector|支持向量||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|统计、机器学习|
AITD-01857|Support Vector Expansion|支持向量展式||[1]||
AITD-01858|Support Vector Machine|支持向量机|SVM|[[1]](https://www.jiqizhixin.com/articles/2017-10-08)[[2]](https://www.nature.com/articles/s41557-021-00716-z)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00251/978-1-78801-789-3)|统计、机器学习|
AITD-01860|Surrogat Loss|替代损失||[1]||
AITD-01861|Surrogate Function|替代函数||[1]||
AITD-01862|Surrogate Loss Function|代理损失函数||[1]||
AITD-01867|Symbolism|符号主义||[1]||
AITD-01878|Tangent Propagation|正切传播||[1]||
AITD-01883|Teacher Forcing|强制教学||[1]||
AITD-01888|Temporal-Difference Learning|时序差分学习||[1]||
AITD-01889|Tensor|张量||[1]||
AITD-01894|Test Error|测试误差||[1]||
AITD-01895|Test Sample|测试样本||[1]||
AITD-01896|Test Set|测试集||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|机器学习|
AITD-01898|Threshold|阈值||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)|数学|
AITD-01899|Threshold Logic Unit|阈值逻辑单元||[1]||
AITD-01900|Threshold-Moving|阈值移动||[1]||
AITD-01901|Tied Weight|捆绑权重||[1]||
AITD-01902|Tikhonov Regularization|Tikhonov正则化||[1]||
AITD-01904|Time Delay Neural Network|时延神经网络|TDNN|[1]||
AITD-01905|Time Homogenous Markov Chain|时间齐次马尔可夫链||[1]||
AITD-01906|Time Step|时间步||[1]||
AITD-01908|Token|词元||[1]||
AITD-01909|Tokenize|词元化||[1]||
AITD-01910|Tokenization|词元化||[1]||
AITD-01911|Tokenizer|词元分析器||[1]||
AITD-01915|Topic Model|话题模型||[1]||
AITD-01916|Topic Modeling|话题分析||[1]||
AITD-01922|Trace|迹||[1]||
AITD-01924|Training|训练||[1]||
AITD-01926|Training Error|训练误差||[1]||
AITD-01928|Training Sample|训练样本||[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-01929|Training Set|训练集||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-01933|Transductive Learning|直推学习||[1]||
AITD-01934|Transductive Transfer Learning|直推迁移学习||[1]||
AITD-01935|Transfer Learning|迁移学习||[[1]](https://www.jiqizhixin.com/articles/2018-01-04-7)[[2]](https://www.nature.com/articles/s41557-021-00716-z)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)||
AITD-01937|Transformer|Transformer||[1]||
AITD-01938|Transformer Model|Transformer模型||[1]||
AITD-01943|Transpose|转置||[1]||
AITD-01944|Transposed Convolution|转置卷积||[1]||
AITD-01948|Trial And Error|试错||[1]||
AITD-01953|Trigram|三元语法||[1]||
AITD-01960|Turing Machine|图灵机||[[1]](https://www.jiqizhixin.com/articles/2017-04-11-7)||
AITD-01971|Underfitting|欠拟合||[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-01976|Undersampling|欠采样||[1]||
AITD-01980|Undirected Graphical Model|无向图模型||[1]||
AITD-01987|Uniform Distribution|均匀分布||[1]||
AITD-01990|Unigram|一元语法||[1]||
AITD-01992|Unit|单元||[1]||
AITD-02000|Universal Approximation Theorem|通用近似定理||[1]||
AITD-02001|Universal Approximator|通用近似器||[1]||
AITD-02002|Universal Function Approximator|通用函数近似器||[1]||
AITD-02003|Unknown Token|未知词元||[1]||
AITD-02010|Unsupervised Layer-Wise Training|无监督逐层训练||[1]||
AITD-02012|Unsupervised Learning|无监督学习|UL|[[1]](https://www.jiqizhixin.com/articles/2017-11-17-5)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)||
AITD-02014|Update Gate|更新门||[1]||
AITD-02017|Upsampling|上采样||[1]||
AITD-02018|V-Structure|V型结构||[1]||
AITD-02020|Validation Set|验证集||[[1]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-02021|Validity Index|有效性指标||[1]||
AITD-02023|Value Function Approximation|值函数近似||[1]||
AITD-02024|Value Iteration|值迭代||[1]||
AITD-02027|Vanishing Gradient Problem|梯度消失问题||[[1]](https://www.jiqizhixin.com/articles/2018-01-07-2)||
AITD-02028|Vapnik-Chervonenkis Dimension|VC维||[1]||
AITD-02029|Variable Elimination|变量消去||[1]||
AITD-02030|Variance|方差||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-02033|Variational Autoencoder|变分自编码器|VAE|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)||
AITD-02040|Variational Inference|变分推断||[1]||
AITD-02041|Vector|向量||[1]||
AITD-02043|Vector Space Model|向量空间模型|VSM|[1]||
AITD-02045|Version Space|版本空间||[1]||
AITD-02050|Viterbi Algorithm|维特比算法||[1]||
AITD-02051|Vocabulary|词表||[1]||
AITD-02055|Warp|线程束||[1]||
AITD-02060|Weak Learner|弱学习器||[1]||
AITD-02062|Weakly Supervised Learning|弱监督学习||[1]||
AITD-02063|Weight|权重||[[1]](https://www.jiqizhixin.com/articles/2018-01-08-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-02064|Weight Decay|权重衰减||[1]||
AITD-02067|Weight Sharing|权共享||[1]||
AITD-02071|Weighted Voting|加权投票||[1]||
AITD-02072|Whitening|白化||[1]||
AITD-02075|Winner-Take-All|胜者通吃||[1]||
AITD-02076|Within-Class Scatter Matrix|类内散度矩阵||[1]||
AITD-02077|Word Embedding|词嵌入||[[1]](https://www.jiqizhixin.com/articles/2017-11-20-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)||
AITD-02078|Word Sense Disambiguation|词义消歧||[1]||
AITD-02079|Word Vector|词向量||[1]||
AITD-02087|Zero Padding|零填充||[1]||
AITD-02091|Zero-Shot Learning|零试学习||[[1]](https://www.jiqizhixin.com/articles/2017-03-31-6)||
AITD-02092|Zipf's Law|齐普夫定律||[1]||
